#ifndef _DOACCEPT_CPP
#define _DOACCEPT_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define WIN32_LEAN_AND_MEAN

#include <Windows.H>
#include <WinSock2.H>
//#include <WinSock.H>
#include <MSTcpIP.h>
#include <Stdio.H>
#include <Stdlib.H>
#include <IOStream>

#include "SockServer.H"
#include "../Source/Routines.H"

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool SocketServer::DoAccept(void)
{
    #ifdef _DEBUG_SOCK_SERVER
    printf("DEBUG: [In Proc]> SocketServer::DoAccept.\n");
    #endif

	if(FD_ISSET(sckcListenSocket, &ReadFDS))
	{
		int iClient = 0;
		int iLength = 0;
		SOCKET sckLocalSocket = 0;

		SOCKADDR_IN RemoteClientSocketAddress;

		iLength = sizeof(SOCKADDR);
		if((sckLocalSocket = accept(sckcListenSocket, (SOCKADDR*)&RemoteClientSocketAddress, &iLength)) == SOCKET_ERROR)
		{
            WriteSysLog("SocketServer::DoAccept : Accept returned SOCKET_ERROR.");
			return false;
		}

		if(sckLocalSocket == 0)
		{
            WriteSysLog("SocketServer::DoAccept : Accept returned 0.");
			return false;
		}

		if(icCurrentClients == icMaxClients)
		{
            WriteSysLog("Accept failed. Too many clients.");

			WSASendDisconnect(sckLocalSocket, NULL);
			shutdown(sckLocalSocket, SD_BOTH);
			closesocket(sckLocalSocket);
			return false;
		}

		if((iClient = SelectFreeSocket()) == -1)
		{
            WriteSysLog("Accept failed. Not enough resources.");
			WSASendDisconnect(sckLocalSocket, NULL);
			shutdown(sckLocalSocket, SD_BOTH);
			closesocket(sckLocalSocket);
			return false;
		}

        if(!OnAcceptConnectClient(iClient))
        {
            WriteSysLog("SocketServer::DoAccept : Accept failed. OnAcceptConnectClient returned false.");
			WSASendDisconnect(sckLocalSocket, NULL);
			shutdown(sckLocalSocket, SD_BOTH);
			closesocket(sckLocalSocket);
        }

        // inet_ntoa(RemoteClientSocketAddress.sin_addr) // IP Address
        // ntohs(RemoteClientSocketAddress.sin_port) // Port

        icClientID[iClient] = icNextClientID++;
		bcConnected[iClient] = true;
		bcDisconnect[iClient] = false;
		sckcSocket[iClient] = sckLocalSocket;

		icCurrentClients++;

		WriteLog(icClientID[iClient], "Connected.");

        return Start_ClientThread(iClient);
	}

	return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

